/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl.ref;

import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefClassInfo;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.PackageUtils;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.service.ISyntheticClassInfo;
import org.spongepowered.asm.util.IConsumer;

public class LocalRefClassGenerator
implements IClassGenerator {
    private static LocalRefClassGenerator INSTANCE;
    private final IConsumer<ISyntheticClassInfo> registry;
    private final Map<Class<?>, LocalRefClassInfo> interfaceToInfo = new HashMap();
    private final Map<String, LocalRefClassInfo> nameToInfo = new HashMap<String, LocalRefClassInfo>();

    public LocalRefClassGenerator(IConsumer<ISyntheticClassInfo> registry) {
        this.registry = registry;
        INSTANCE = this;
    }

    public String getName() {
        return "MixinExtras LocalRefImpl";
    }

    public boolean generate(String name, ClassNode classNode) {
        LocalRefClassInfo info = this.nameToInfo.get(name);
        if (info == null) {
            return false;
        }
        classNode.visit(52, 33, info.getName(), null, Type.getInternalName(Object.class), null);
        this.generateClass(classNode, info);
        classNode.visitEnd();
        info.markAsLoaded();
        return true;
    }

    public String getForType(IMixinInfo mixin, Type type) {
        Class<?> refInterface = LocalRefUtils.getInterfaceFor(type);
        LocalRefClassInfo info = this.interfaceToInfo.get(refInterface);
        if (info != null) {
            return info.getName();
        }
        String desc = type.getDescriptor();
        info = new LocalRefClassInfo(mixin, refInterface, desc.length() == 1 ? desc : Type.getDescriptor(Object.class));
        this.interfaceToInfo.put(refInterface, info);
        this.nameToInfo.put(info.getClassName(), info);
        this.registry.accept((Object)info);
        return info.getName();
    }

    private void generateClass(ClassNode node, LocalRefClassInfo info) {
        for (String name : PackageUtils.getAllClassNames(info.getInterfaceName())) {
            node.interfaces.add(name.replace('.', '/'));
        }
        node.visitField(2, "value", info.getDesc(), null, null);
        MethodVisitor ctor = node.visitMethod(1, "<init>", "(" + info.getDesc() + ")V", null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        ctor.visitVarInsn(25, 0);
        ctor.visitVarInsn(Type.getType((String)info.getDesc()).getOpcode(21), 1);
        ctor.visitFieldInsn(181, info.getName(), "value", info.getDesc());
        ctor.visitInsn(177);
        ctor.visitMaxs(3, 3);
        ctor.visitEnd();
        MethodVisitor getter = node.visitMethod(1, "get", "()" + info.getDesc(), null, null);
        getter.visitCode();
        getter.visitVarInsn(25, 0);
        getter.visitFieldInsn(180, info.getName(), "value", info.getDesc());
        getter.visitInsn(Type.getType((String)info.getDesc()).getOpcode(172));
        getter.visitMaxs(2, 1);
        getter.visitEnd();
        MethodVisitor setter = node.visitMethod(1, "set", "(" + info.getDesc() + ")V", null, null);
        setter.visitCode();
        setter.visitVarInsn(25, 0);
        setter.visitVarInsn(Type.getType((String)info.getDesc()).getOpcode(21), 1);
        setter.visitFieldInsn(181, info.getName(), "value", info.getDesc());
        setter.visitInsn(177);
        setter.visitMaxs(3, 3);
        setter.visitEnd();
    }

    public static LocalRefClassGenerator getInstance() {
        return INSTANCE;
    }
}

